package com.example.helloandroid;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.Menu;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.EditText;

/**
 * Our first Activity.  If you look in the Android Manifest, you will see that this Activity is registered to receive the ACTION_MAIN broadcast.
 * This means that this is the first screen the user will see when they start their application.  It is noteworthy to know that the name of this class
 * does NOT have to be Main; I have done it this was just because I enjoy using the syntax of Java.
 * 
 * Note that the manifest states that this Activity must be in landscape view.
 * 
 * @author Marc J. McDougall
 */
public class Main extends Activity {

	//Public static variable that holds the key to the text contained in the extras of the Intent.
	public static final String TEXT_TAG = "main_text";
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		
		//Must be called at the start of each of the activity life-cycle calls
		super.onCreate(savedInstanceState);
		
		//Sets the view of the screen to the xml resource main.  You can find this resource in the res/layout/ folder.
		setContentView(R.layout.main);
		
		//Reference to the Button you see on the screen (findViewById()) is how you obtain these references.
		Button send = (Button) findViewById(R.id.main_button);
		
		//Reference to the Edit Text field you see on the screen (findViewById()) is how you obtain these references.
		final EditText et = (EditText) findViewById(R.id.title_edit_text);
		
		//Set the click listener (also listens for touches) on the button.  We then create a new onClickListener() to handle the touch event.
		send.setOnClickListener(new OnClickListener() {
			
			@Override
			public void onClick(View v) {
				
				//Create a new activity that will switch the Activity.
				Intent activity_switcher = new Intent(Main.this, Result.class);
				
				//Adds the value of the EditText field to the extra package that is coupled with the intent.
				activity_switcher.putExtra(TEXT_TAG, et.getText().toString());
				
				//Starts the next Activity (the screen that displays the result)
				startActivity(activity_switcher);
			}
		});
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		
		// Inflate the menu; this adds items to the action bar if it is present.  This is not used in our example.
		getMenuInflater().inflate(R.menu.main, menu);
		return true;
	}

}
